<?php
include 'includes/db.php';

/* ===== Get Appointment ID ===== */
$id = intval($_GET['id'] ?? 0);
if ($id <= 0) {
    die("Invalid appointment.");
}

/* ===== Fetch Appointment ===== */
$stmt = $conn->prepare(
    "SELECT id, name, phone, appointment_date, appointment_time, payment_status
     FROM appointments WHERE id=?"
);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$appointment = $result->fetch_assoc();

if (!$appointment) {
    die("Appointment not found.");
}

/* ===== Handle Payment Submit ===== */
$success = false;
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    if (
        !isset($_FILES['payment_screenshot']) ||
        $_FILES['payment_screenshot']['error'] !== UPLOAD_ERR_OK
    ) {
        $error = "Please upload payment screenshot.";
    } else {

        /* Validate image */
        $allowed = ['image/jpeg','image/png','image/webp'];
        if (!in_array($_FILES['payment_screenshot']['type'], $allowed)) {
            $error = "Only JPG, PNG or WEBP images allowed.";
        } else {

            /* Upload folder */
            $uploadDir = "uploads/payments/";
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0755, true);
            }

            $fileName = time().'_'.preg_replace(
                "/[^a-zA-Z0-9._-]/",
                "",
                $_FILES['payment_screenshot']['name']
            );

            move_uploaded_file(
                $_FILES['payment_screenshot']['tmp_name'],
                $uploadDir.$fileName
            );

            /* Update appointment */
            $up = $conn->prepare(
                "UPDATE appointments
                 SET payment_status='Paid',
                     payment_screenshot=?
                 WHERE id=?"
            );
            $up->bind_param("si", $fileName, $id);
            $up->execute();

            $success = true;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Complete Payment</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
body{
  background:#f4f7fb;
  font-family:Poppins,Arial;
  text-align:center
}
.box{
  max-width:420px;
  margin:80px auto;
  background:#fff;
  padding:35px;
  border-radius:22px;
  box-shadow:0 15px 35px rgba(0,0,0,.15)
}
img.qr{width:240px;margin:15px auto;display:block}
input,button{
  width:100%;
  padding:12px;
  margin:10px 0;
  border-radius:10px;
  border:1px solid #ccc;
  font-size:15px
}
button{
  background:linear-gradient(135deg,#5563DE,#74ABE2);
  color:#fff;
  border:none;
  font-weight:600;
  cursor:pointer
}
.success{color:#28a745;font-weight:600}
.error{color:#d9534f;font-size:14px}
</style>
</head>

<body>

<div class="box">

<?php if ($success): ?>

  <h2 class="success">✅ Thanks for Payment</h2>
  <p>
    Your appointment has been booked.<br>
    <strong>Doctor will call you shortly.</strong>
  </p>
  <a href="index.php">Go to Home</a>

<?php else: ?>

  <h2>Pay Consultation Fee</h2>

  <p>
    <strong>Name:</strong> <?= htmlspecialchars($appointment['name']) ?><br>
    <strong>Date:</strong> <?= date('d M Y', strtotime($appointment['appointment_date'])) ?><br>
    <strong>Time:</strong> <?= date('h:i A', strtotime($appointment['appointment_time'])) ?>
  </p>

  <p><strong>Fee:</strong> ₹500</p>

  <!-- QR CODE IMAGE -->
  <img src="assets/phonepe_qr.png" class="qr" alt="PhonePe QR">

  <p style="font-size:14px;color:#555">
    QR scan karke payment karein.<br>
    Payment ke baad screenshot upload karein.
  </p>

  <?php if ($error): ?>
    <p class="error"><?= $error ?></p>
  <?php endif; ?>

  <form method="POST" enctype="multipart/form-data">
    <input type="file" name="payment_screenshot" accept="image/*" required>
    <button type="submit">Submit Payment</button>
  </form>

<?php endif; ?>

</div>

</body>
</html>
