<?php
include 'includes/db.php';
$selected_date = date('Y-m-d');
$status_result = '';

if(isset($_POST['track_appointment'])){
    $phone = $_POST['track_phone'];
    $date  = $_POST['track_date'];

    $stmt = $conn->prepare(
      "SELECT status FROM appointments WHERE phone=? AND appointment_date=?"
    );
    $stmt->bind_param("ss",$phone,$date);
    $stmt->execute();
    $res = $stmt->get_result();

    if($res->num_rows){
        $row = $res->fetch_assoc();
        $status_result = "Your appointment status on <b>".date('d M Y',strtotime($date)).
                         "</b> is <b>".$row['status']."</b>";
    } else {
        $status_result = "No appointment found with given details.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Dr. Atul Kumar Soni | Trusted Homeopathic Doctor</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
*{margin:0;padding:0;box-sizing:border-box;font-family:Poppins,Arial,sans-serif}
body{background:#f4f7fb;color:#333;line-height:1.6}

/* ===== NAVBAR ===== */
nav{
  background:#fff;
  display:flex;
  justify-content:space-between;
  align-items:center;
  padding:15px 30px;
  box-shadow:0 5px 20px rgba(0,0,0,.08);
  position:sticky;
  top:0;
  z-index:1000;
}
.logo{font-size:22px;font-weight:700;color:#007bff}

.nav-links{
  display:flex;
  align-items:center;
}
.nav-links a{
  text-decoration:none;
  color:#333;
  margin:0 10px;
  font-weight:500;
  padding:8px 12px;
  border-radius:6px;
}
.nav-links a:hover{background:#f1f1f1}
.nav-links a.active{background:#007bff;color:#fff}

.menu-toggle{
  display:none;
  font-size:26px;
  cursor:pointer;
}

/* ===== HERO ===== */
.hero{
  background:linear-gradient(135deg,#5563DE,#74ABE2);
  color:#fff;
  padding:90px 20px;
}
.hero-box{
  max-width:1200px;
  margin:auto;
  display:flex;
  align-items:center;
  gap:40px;
  flex-wrap:wrap;
}
.hero-text{flex:1}
.hero-text h1{font-size:3em;line-height:1.2}
.hero-text p{margin:20px 0;font-size:1.1em}
.hero-text a{
  display:inline-block;
  background:#ff758c;
  color:#fff;
  padding:14px 26px;
  border-radius:30px;
  text-decoration:none;
  font-weight:600;
  margin-right:15px;
}
.hero-text a.secondary{background:#fff;color:#5563DE}
.hero-img{flex:1;text-align:center}
.hero-img img{
  width:380px;
  max-width:100%;
  border-radius:30px;
  box-shadow:0 20px 40px rgba(0,0,0,.3)
}

/* ===== SECTIONS ===== */
section{
  padding:70px 20px;
  max-width:1200px;
  margin:auto;
}
section h2{
  text-align:center;
  font-size:2.3em;
  color:#2a2a72;
  margin-bottom:40px;
}

/* TRUST */
.trust{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(220px,1fr));
  gap:25px;
}
.trust-box{
  background:#fff;
  padding:30px;
  border-radius:25px;
  text-align:center;
  box-shadow:0 12px 30px rgba(0,0,0,.1);
}
.trust-box h3{font-size:2em;color:#5563DE}

/* SERVICES */
.services{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(250px,1fr));
  gap:30px;
}
.service{
  background:#fff;
  padding:30px;
  border-radius:25px;
  box-shadow:0 12px 30px rgba(0,0,0,.1);
}
.service h3{color:#5563DE;margin-bottom:10px}

/* APPOINTMENT */
.appointment{
  background:linear-gradient(135deg,#74ABE2,#5563DE);
  padding:50px;
  border-radius:35px;
  color:#fff;
  max-width:550px;
  margin:auto;
}
input,select,textarea,button{
  width:100%;
  padding:13px;
  margin:8px 0;
  border-radius:12px;
  border:none;
}
button{background:#ff758c;color:#fff;font-weight:600;cursor:pointer}
.slots{display:flex;flex-wrap:wrap;gap:10px}
.slot{
  background:#fff;
  color:#333;
  padding:10px;
  border-radius:10px;
  cursor:pointer;
}
.slot.booked{background:#ccc;color:#777}
.slot.selected{background:#ff758c;color:#fff}

/* TRACK */
.track{
  background:#fff;
  max-width:420px;
  margin:auto;
  padding:30px;
  border-radius:25px;
  box-shadow:0 12px 30px rgba(0,0,0,.12);
  text-align:center;
}

/* FOOTER */
footer{
  background:#2a2a72;
  color:#fff;
  text-align:center;
  padding:25px;
  margin-top:60px;
}

/* ===== MOBILE RESPONSIVE ===== */
@media(max-width:768px){

  .menu-toggle{display:block}

  .nav-links{
    display:none;
    position:absolute;
    top:65px;
    left:0;
    width:100%;
    background:#fff;
    flex-direction:column;
    padding:15px;
  }
  .nav-links.show{display:flex}
  .nav-links a{margin:6px 0}

  .hero-box{
    flex-direction:column;
    text-align:center;
  }
  .hero-text h1{font-size:2.1em}
  .hero-img img{width:260px;margin-top:20px}
}
</style>
</head>

<body>

<nav>
  <div class="logo">Dr. Atul Soni</div>
  <div class="menu-toggle" onclick="toggleMenu()">☰</div>
  <div class="nav-links" id="navLinks">
    <a href="index.php" class="active">Home</a>
    <a href="About.php">About Doctor</a>
    <a href="services.php">Services</a>
    <a href="BookAppointmant.php">Appointment</a>
    <a href="track.php">Track</a>
    <a href="contact.php">Contact</a>
  </div>
</nav>

<!-- HERO -->
<div class="hero">
  <div class="hero-box">
    <div class="hero-text">
      <h1>Trusted Homeopathic Care<br>For You & Your Family</h1>
      <p>Safe • Natural • Effective treatment for chronic and lifestyle diseases.</p>
      <a href="#appointment">Book Appointment</a>
      <a href="#services" class="secondary">Our Services</a>
    </div>
    <div class="hero-img">
      <img src="https://cdn.pixabay.com/photo/2016/11/14/03/16/doctor-1822451_1280.jpg">
    </div>
  </div>
</div>

<!-- TRUST -->
<section>
  <div class="trust">
    <div class="trust-box"><h3>5+</h3><p>Years Experience</p></div>
    <div class="trust-box"><h3>500+</h3><p>Happy Patients</p></div>
    <div class="trust-box"><h3>100%</h3><p>Natural Treatment</p></div>
  </div>
</section>

<!-- SERVICES -->
<section id="services">
<h2>Our Specialities</h2>
<div class="services">
  <div class="service"><h3>Skin & Hair</h3><p>Acne, eczema, hair fall solutions.</p></div>
  <div class="service"><h3>Allergy & Asthma</h3><p>Long-term allergy relief.</p></div>
  <div class="service"><h3>Digestive Issues</h3><p>Gas, acidity, IBS care.</p></div>
  <div class="service"><h3>Child Care</h3><p>Safe & gentle homeopathy.</p></div>
</div>
</section>

<!-- APPOINTMENT -->
<section id="appointment">
<h2>Book Appointment</h2>
<div class="appointment">
<form action="save_appointment.php" method="POST">
<input type="text" name="name" placeholder="Full Name" required>
<input type="text" name="phone" placeholder="Phone Number" required>
<input type="email" name="email" placeholder="Email">
<select name="appointment_type" required>
<option value="Online">Online</option>
<option value="Offline">Offline</option>
</select>
<input type="date" name="appointment_date" value="<?= $selected_date ?>" required>
<textarea name="disease_description" placeholder="Describe your problem"></textarea>
<div id="timeSlots" class="slots"><?php include 'get_slots.php'; ?></div>
<button type="submit">Confirm Appointment</button>
</form>
</div>
</section>

<!-- TRACK -->
<section id="track">
<h2>Track Appointment</h2>
<div class="track">
<form method="POST">
<input type="text" name="track_phone" placeholder="Phone Number" required>
<input type="date" name="track_date" required>
<button name="track_appointment">Check Status</button>
</form>
<?php if($status_result): ?><p><?= $status_result ?></p><?php endif; ?>
</div>
</section>

<footer>
© <?=date('Y')?> Dr. Atul Kumar Soni | Designed by Ashish Digital Service
</footer>

<script>
function toggleMenu(){
  document.getElementById("navLinks").classList.toggle("show");
}
</script>

</body>
</html>
