<?php
include 'includes/db.php';

date_default_timezone_set('Asia/Kolkata');

$date = $_GET['date'] ?? date('Y-m-d');
$today = date('Y-m-d');
$currentTimestamp = time(); // current server timestamp

// Clinic time slots
$slots = [
  "10:00","10:30","11:00","11:30",
  "12:00","12:30","13:00","13:30",
  "14:00","14:30","15:00","15:30",
  "16:00","16:30","17:00","17:30"
];

// Fetch booked slots
$booked = [];
$stmt = $conn->prepare(
  "SELECT appointment_time FROM appointments WHERE appointment_date=?"
);
$stmt->bind_param("s", $date);
$stmt->execute();
$res = $stmt->get_result();

while($row = $res->fetch_assoc()){
  $booked[] = substr($row['appointment_time'],0,5);
}
$stmt->close();

foreach($slots as $time){

  // Build full timestamp for slot
  $slotTimestamp = strtotime($date . ' ' . $time);

  $isBooked = in_array($time, $booked);
  $isPast   = ($date == $today && $slotTimestamp <= $currentTimestamp);

  $class = "slot";
  if($isBooked || $isPast){
    $class .= " booked";
  }

  echo '<div class="'.$class.'">';
  echo date("h:i A", strtotime($time));

  if(!$isBooked && !$isPast){
    echo '<input type="radio" name="appointment_time"
           value="'.$time.'" hidden>';
  }

  echo '</div>';
}
