// ========== Doctor Appointment Script ==========

// Run after DOM loaded
document.addEventListener("DOMContentLoaded", function () {
    
    const dateInput = document.getElementById("appointment_date");
    const timeSelect = document.getElementById("appointment_time");
    const loader = document.getElementById("slotLoader");

    // Function to fetch available slots dynamically
    async function loadSlots(date) {
        if (!date || !timeSelect) return;

        // Show loader text
        if (loader) loader.style.display = "inline-block";
        timeSelect.innerHTML = "<option>Loading...</option>";

        try {
            const response = await fetch(`get_slots.php?date=${date}`);
            const data = await response.json();

            timeSelect.innerHTML = ""; // clear
            data.forEach(slot => {
                const option = document.createElement("option");
                option.value = slot.time;
                option.textContent = slot.display;

                // Disable booked slots
                if (slot.booked) {
                    option.disabled = true;
                    option.style.color = "#999";
                    option.style.textDecoration = "line-through";
                }
                timeSelect.appendChild(option);
            });
        } catch (err) {
            console.error("Error fetching slots:", err);
            timeSelect.innerHTML = "<option>Error loading slots</option>";
        }

        if (loader) loader.style.display = "none";
    }

    // Date change event
    if (dateInput) {
        dateInput.addEventListener("change", function () {
            const selectedDate = this.value;
            loadSlots(selectedDate);
        });
    }

    // Form validation before submit
    const form = document.querySelector("form.appointment-form");
    if (form) {
        form.addEventListener("submit", function (e) {
            const inputs = form.querySelectorAll("input[required], select[required]");
            let valid = true;

            inputs.forEach(input => {
                if (!input.value.trim()) {
                    valid = false;
                    input.style.border = "1px solid red";
                } else {
                    input.style.border = "1px solid #ccc";
                }
            });

            if (!valid) {
                e.preventDefault();
                alert("Please fill all required fields.");
            }
        });
    }
});
