<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Our Services | Dr. Atul Kumar Soni</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
*{margin:0;padding:0;box-sizing:border-box;font-family:Poppins,Arial}
body{background:#f4f7fb;color:#333}

/* ===== NAVBAR ===== */
nav{
  background:#fff;
  display:flex;
  justify-content:space-between;
  align-items:center;
  padding:15px 30px;
  box-shadow:0 5px 20px rgba(0,0,0,.08);
  position:sticky;
  top:0;
  z-index:1000;
}

/* Logo */
.logo{
  font-size:22px;
  font-weight:700;
  color:#007bff;
}

/* Nav links */
.nav-links a{
  text-decoration:none;
  color:#333;
  margin:0 10px;
  font-weight:500;
  padding:8px 12px;
  border-radius:6px;
  transition:0.3s;
}

/* Hover effect */
.nav-links a:hover{
  background:#f1f1f1;
}

/* ACTIVE TAB */
.nav-links a.active{
  background:#007bff;
  color:#fff;
}


/* ===== SERVICES ===== */
.container{
  max-width:1100px;
  margin:50px auto;
  padding:0 20px
}
.services{
  display:grid;
  grid-template-columns:repeat(auto-fit,minmax(250px,1fr));
  gap:25px
}
.service{
  background:#fff;
  padding:30px;
  border-radius:22px;
  box-shadow:0 10px 30px rgba(0,0,0,.1);
  transition:.4s;
  text-align:center
}
.service:hover{
  transform:translateY(-8px);
  box-shadow:0 20px 40px rgba(0,0,0,.15)
}
.service h3{
  color:#5563DE;
  margin-bottom:10px
}
.service p{
  font-size:.95em;
  line-height:1.6;
  color:#555
}

/* ===== FOOTER ===== */
footer{
  background:#2a2a72;
  color:#fff;
  text-align:center;
  padding:20px;
  margin-top:60px
}

@media(max-width:600px){
  .header h1{font-size:2em}
}
</style>
</head>

<body>

<nav>
  <div class="logo">Dr. Atul Soni</div>

  <div class="nav-links">
    <a href="index.php" class="<?= basename($_SERVER['PHP_SELF'])=='index.php'?'active':'' ?>">Home</a>
    <a href="About.php" class="<?= basename($_SERVER['PHP_SELF'])=='About.php'?'active':'' ?>">About Doctor</a>
    <a href="services.php" class="<?= basename($_SERVER['PHP_SELF'])=='services.php'?'active':'' ?>">Services</a>
    <a href="BookAppointmant.php" class="<?= basename($_SERVER['PHP_SELF'])=='BookAppointmant.php'?'active':'' ?>">Appointment</a>
    <a href="track.php">Track</a>
    <a href="contact.php" class="<?= basename($_SERVER['PHP_SELF'])=='contact.php'?'active':'' ?>">Contact</a>
  </div>
</nav>

<div class="header">
  <center>
  <h1>Our Homeopathic Services</h1>
  <p>Natural, Safe & Effective Treatment</p>
</center>
</div>

<div class="container">
  <div class="services">

    <div class="service">
      <h3>Skin & Hair Treatment</h3>
      <p>Effective homeopathic solutions for acne, eczema, psoriasis, hair fall and dandruff.</p>
    </div>

    <div class="service">
      <h3>Allergy & Asthma Care</h3>
      <p>Long-term relief from allergic rhinitis, asthma and breathing problems.</p>
    </div>

    <div class="service">
      <h3>Digestive Disorders</h3>
      <p>Treatment for acidity, gas, constipation, IBS and liver-related issues.</p>
    </div>

    <div class="service">
      <h3>Joint Pain & Arthritis</h3>
      <p>Reduce pain, stiffness and improve mobility naturally.</p>
    </div>

    <div class="service">
      <h3>Child Health Care</h3>
      <p>Safe and gentle treatment to boost immunity and overall development.</p>
    </div>

    <div class="service">
      <h3>Stress & Sleep Problems</h3>
      <p>Natural treatment for anxiety, stress, insomnia and mental fatigue.</p>
    </div>

  </div>
</div>

<footer>
© <?=date('Y')?> Dr. Atul Kumar Soni | Designed by eKitaabGhar
</footer>

</body>
</html>
