<?php
include 'includes/db.php';
$success = '';

if(isset($_POST['submit_query'])){
  $name    = $_POST['name'];
  $phone   = $_POST['phone'];
  $email   = $_POST['email'];
  $message = $_POST['message'];

  $stmt = $conn->prepare(
    "INSERT INTO contact_queries (name, phone, email, message) VALUES (?,?,?,?)"
  );
  $stmt->bind_param("ssss",$name,$phone,$email,$message);
  $stmt->execute();

  if($stmt){
    $success = "Your query has been submitted successfully. We will contact you soon.";
  }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Contact Us | Dr. Atul Kumar Soni</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
*{margin:0;padding:0;box-sizing:border-box;font-family:Poppins,Arial}
body{background:#f4f7fb;color:#333}

/* NAVBAR */
nav{
  background:#fff;display:flex;justify-content:space-between;
  align-items:center;padding:15px 30px;
  box-shadow:0 5px 20px rgba(0,0,0,.08);
  position:sticky;top:0;z-index:1000;
}
.logo{font-size:22px;font-weight:700;color:#007bff}
.nav-links a{
  text-decoration:none;color:#333;margin:0 10px;
  font-weight:500;padding:8px 12px;border-radius:6px;transition:.3s
}
.nav-links a:hover{background:#f1f1f1}
.nav-links a.active{background:#007bff;color:#fff}

/* HEADER */
.header{
  background:linear-gradient(135deg,#5563DE,#74ABE2);
  color:#fff;text-align:center;padding:70px 20px
}
.header h1{font-size:2.6em}

/* CONTACT BOX */
.container{
  max-width:650px;margin:50px auto;padding:35px;
  background:#fff;border-radius:25px;
  box-shadow:0 15px 35px rgba(0,0,0,.15);
}
.container h2{text-align:center;color:#2a2a72;margin-bottom:20px}
input,textarea,button{
  width:100%;padding:14px;margin:10px 0;
  border-radius:12px;border:none;font-size:15px
}
textarea{resize:none;height:120px}
button{
  background:#007bff;color:#fff;
  font-weight:600;cursor:pointer
}
.success{
  background:#e7f7ec;color:#0a7a3b;
  padding:12px;border-radius:10px;
  margin-bottom:15px;text-align:center
}

/* FOOTER */
footer{
  background:#2a2a72;color:#fff;
  text-align:center;padding:20px;margin-top:60px
}
</style>
</head>

<body>

<nav>
  <div class="logo">Dr. Atul Soni</div>
  <div class="nav-links">
    <a href="index.php">Home</a>
    <a href="About.php">About Doctor</a>
    <a href="services.php">Services</a>
    <a href="BookAppointmant.php">Appointment</a>
    <a href="track.php">Track</a>
    <a href="contact.php" class="active">Contact</a>
  </div>
</nav>

<div class="header">
  <h1>Contact Us</h1>
</div>

<div class="container">
  <h2>Send Your Query</h2>

  <?php if($success): ?>
    <div class="success"><?= $success ?></div>
  <?php endif; ?>

  <form method="POST">
    <input type="text" name="name" placeholder="Your Name" required>
    <input type="text" name="phone" placeholder="Phone Number" required>
    <input type="email" name="email" placeholder="Email (optional)">
    <textarea name="message" placeholder="Write your query..." required></textarea>
    <button name="submit_query">Submit Query</button>
  </form>
</div>

<footer>
© <?=date('Y')?> Dr. Atul Kumar Soni | Designed by Ashish Digital Service
</footer>

</body>
</html>
