<?php
include 'includes/db.php';
$selected_date = $_GET['date'] ?? date('Y-m-d');
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Book Appointment | Dr. Atul Kumar Soni</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
*{margin:0;padding:0;box-sizing:border-box;font-family:Poppins,Arial}
body{background:#f4f7fb;color:#333}

/* ===== NAVBAR ===== */
nav{
  background:#fff;
  display:flex;
  justify-content:space-between;
  align-items:center;
  padding:15px 30px;
  box-shadow:0 5px 20px rgba(0,0,0,.08);
  position:sticky;
  top:0;
  z-index:1000;
}

/* Logo */
.logo{
  font-size:22px;
  font-weight:700;
  color:#007bff;
}

/* Nav links */
.nav-links a{
  text-decoration:none;
  color:#333;
  margin:0 10px;
  font-weight:500;
  padding:8px 12px;
  border-radius:6px;
  transition:0.3s;
}

/* Hover effect */
.nav-links a:hover{
  background:#f1f1f1;
}

/* ACTIVE TAB */
.nav-links a.active{
  background:#007bff;
  color:#fff;
}


/* ===== CONTAINER ===== */
.container{
  max-width:520px;
  margin:50px auto;
  background:linear-gradient(135deg,#74ABE2,#5563DE);
  padding:35px;
  border-radius:25px;
  color:#fff;
  box-shadow:0 15px 35px rgba(0,0,0,.2)
}
.container h2{text-align:center;margin-bottom:20px}

/* ===== FORM ===== */
input,select,textarea,button{
  width:100%;
  padding:12px;
  margin:8px 0;
  border-radius:12px;
  border:none;
  font-size:15px
}
textarea{resize:none}
button{
  background:linear-gradient(135deg,#ff758c,#ff7eb9);
  color:#fff;
  font-weight:600;
  cursor:pointer
}
button:hover{transform:scale(1.03)}

/* ===== SLOTS ===== */
.slots{display:flex;flex-wrap:wrap;gap:10px;margin-top:10px}
.slot{
  background:#fff;
  color:#333;
  padding:10px;
  border-radius:10px;
  cursor:pointer;
  text-align:center;
  flex:1 1 30%
}
.slot.booked{background:#ccc;color:#777;cursor:not-allowed}
.slot.selected{background:#ff758c;color:#fff}

/* ===== FOOTER ===== */
footer{
  text-align:center;
  padding:20px;
  margin-top:40px;
  background:#2a2a72;
  color:#fff
}

@media(max-width:600px){
  .container{margin:30px 15px}
}
</style>
</head>

<body>

<nav>
  <div class="logo">Dr. Atul Soni</div>

  <div class="nav-links">
    <a href="index.php" class="<?= basename($_SERVER['PHP_SELF'])=='index.php'?'active':'' ?>">Home</a>
    <a href="About.php" class="<?= basename($_SERVER['PHP_SELF'])=='About.php'?'active':'' ?>">About Doctor</a>
    <a href="services.php" class="<?= basename($_SERVER['PHP_SELF'])=='services.php'?'active':'' ?>">Services</a>
    <a href="BookAppointmant.php" class="<?= basename($_SERVER['PHP_SELF'])=='BookAppointmant.php'?'active':'' ?>">Appointment</a>
    <a href="track.php">Track</a>
    <a href="contact.php" class="<?= basename($_SERVER['PHP_SELF'])=='contact.php'?'active':'' ?>">Contact</a>
  </div>
</nav>


<div class="container">
<h2>Book Your Appointment</h2>

<form action="save_appointment.php" method="POST">

<input type="text" name="name" placeholder="Full Name" required>
<input type="text" name="phone" placeholder="Phone Number" required>
<input type="email" name="email" placeholder="Email">

<select name="appointment_type" required>
  <option value="">Select Appointment Type</option>
  <option value="Online">Online</option>
  <option value="Offline">Offline</option>
</select>

<input type="date" name="appointment_date" id="appointment_date"
       value="<?= $selected_date ?>"
       min="<?= date('Y-m-d') ?>"
       required>


<textarea name="disease_description" rows="3"
          placeholder="Describe your health issue"></textarea>

<h4>Select Time Slot</h4>
<div id="timeSlots" class="slots">
  <?php include 'get_slots.php'; ?>
</div>

<button type="submit">Confirm Appointment</button>
</form>
</div>

<footer>
© <?=date('Y')?> Dr. Atul Kumar Soni | Designed by Ashish Digital Service
</footer>

<script>
function activateSlots(){
 document.querySelectorAll(".slot").forEach(slot=>{
  slot.onclick=function(){
   if(this.classList.contains("booked")) return;
   document.querySelectorAll(".slot").forEach(s=>s.classList.remove("selected"));
   this.classList.add("selected");
   this.querySelector("input").checked=true;
  }
 });
}
activateSlots();

document.getElementById("appointment_date").addEventListener("change",function(){
 fetch("get_slots.php?date="+this.value)
 .then(r=>r.text())
 .then(html=>{
   document.getElementById("timeSlots").innerHTML=html;
   activateSlots();
 });
});
</script>

</body>
</html>
