<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>About Doctor | Dr. Atul Kumar Soni</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
*{margin:0;padding:0;box-sizing:border-box;font-family:Poppins,Arial}
body{background:#f4f7fb;color:#333}

/* NAVBAR */
nav{
  background:#fff;
  display:flex;
  justify-content:space-between;
  align-items:center;
  padding:15px 30px;
  box-shadow:0 5px 20px rgba(0,0,0,.08);
  position:sticky;
  top:0;
  z-index:1000;
}

/* Logo */
.logo{
  font-size:22px;
  font-weight:700;
  color:#007bff;
}

/* Nav links */
.nav-links a{
  text-decoration:none;
  color:#333;
  margin:0 10px;
  font-weight:500;
  padding:8px 12px;
  border-radius:6px;
  transition:0.3s;
}

/* Hover effect */
.nav-links a:hover{
  background:#f1f1f1;
}

/* ACTIVE TAB */
.nav-links a.active{
  background:#007bff;
  color:#fff;
}

/* HEADER */
.header{
  background:linear-gradient(135deg,#5563DE,#74ABE2);
  color:#fff;text-align:center;padding:70px 20px
}
.header h1{font-size:2.6em}

/* CONTENT */
.container{
  max-width:1000px;margin:50px auto;padding:0 20px;
  display:flex;gap:40px;align-items:center;flex-wrap:wrap
}
.container img{
  width:360px;border-radius:25px;
  box-shadow:0 15px 35px rgba(0,0,0,.2)
}
.text{flex:1}
.text h2{color:#2a2a72;margin-bottom:15px}
.text p{line-height:1.8;color:#555}

/* FOOTER */
footer{
  background:#2a2a72;color:#fff;text-align:center;
  padding:20px;margin-top:60px
}

@media(max-width:768px){
  .container{flex-direction:column;text-align:center}
  .container img{width:90%}
}
</style>
</head>

<body>

<nav>
  <div class="logo">Dr. Atul Soni</div>

  <div class="nav-links">
    <a href="index.php" class="<?= basename($_SERVER['PHP_SELF'])=='index.php'?'active':'' ?>">Home</a>
    <a href="About.php" class="<?= basename($_SERVER['PHP_SELF'])=='About.php'?'active':'' ?>">About Doctor</a>
    <a href="services.php" class="<?= basename($_SERVER['PHP_SELF'])=='services.php'?'active':'' ?>">Services</a>
    <a href="BookAppointmant.php" class="<?= basename($_SERVER['PHP_SELF'])=='BookAppointmant.php'?'active':'' ?>">Appointment</a>
    <a href="track.php">Track</a>
    <a href="contact.php" class="<?= basename($_SERVER['PHP_SELF'])=='contact.php'?'active':'' ?>">Contact</a>
  </div>
</nav>


<div class="header">
  <h1>About the Doctor</h1>
</div>

<div class="container">
  <img src="https://cdn.pixabay.com/photo/2016/11/14/03/16/doctor-1822451_1280.jpg" alt="Doctor">
  <div class="text">
    <h2>Dr. Atul Kumar Soni (BHMS)</h2>
    <p>
      Dr. Atul Kumar Soni is an experienced homeopathic consultant dedicated to
      providing safe, natural and effective treatment. With over 5 years of
      experience, he has successfully treated patients suffering from chronic
      diseases, allergies, skin problems, digestive disorders and lifestyle issues.
    </p>
    <p>
      His approach focuses on treating the root cause of illness rather than
      suppressing symptoms, ensuring long-term relief and improved quality of life.
    </p>
  </div>
</div>

<footer>
© <?=date('Y')?> Dr. Atul Kumar Soni | Designed by eKitaabGhar
</footer>

</body>
</html>
